﻿/*	VERSION:	1.6

GOAL:  exactly duplicate the old behavior  (flaws and all),  but ALSO allow nested paths

USAGE:
	#include "functions/parseVariablePaths.as"
	input = "text says [RAM.myVar]"
	result = parseVariablePaths( input );		// text says value

WHAT THIS DOES:
	converts the contents within []
	
HANDLES:
	evaluate variable paths
		[myvar]
	create objects
		[var1:42,var2:merf]
	preserves strings
		text says [var1]  ->  text says value
		my text  ->  my text
	
RETURNS:
	strings
	undefined
	new objects
*/
#include "../gameFunctions/makeStringObject.as"
#include "../gameFunctions/nestedEval.as"
parseVariablePaths = function( input, defaultContainer )
{
	var defaultContainer = (defaultContainer) ? defaultContainer : "RAM";
	var output = input;
	
	// only evaluate string input, else pass-through
	if( typeof(input)=="string" )
	{// if:  input is a string
		var objectDetect = input.indexOf(":");
		if(objectDetect>-1)
		{// if:  it's an object spec
			// replace [] with {} for compatibility
			var object_str = input.split("[").join("{");
			object_str = object_str.split("]").join("}");
			// make the object
			output = makeStringObject( object_str );
		}// if:  it's an object spec
		else
		{// if:  it's a string
			var result = nestedEval( input, defaultContainer );		// eval al lpaths and run functions
			output = getImpliedValue( result );				// convert output to implied datatype
			
			// add original quirks & flaws
			if(input!=undefined){
				if(input.indexOf("(")!=-1)
				{// if:  input contains function call
					if(output != undefined)
						output = String(output);
				}// if:  input contains function call
				else
				{// if:  input does NOT have a function call
					if(output=="[object Object]")
						output = "undefined";
					if(output==undefined)
						output = "undefined";
				}// if:  input does NOT have a function call
			}// if:  input exists
		}// if:  it's a string
	}// if:  input is a string
	// create object
	return output;
}// parseVariablePaths()